/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.workers;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.NaturesCompassConfig;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.utils.BiomeUtils;
import com.chaosthedude.naturescompass.workers.WorldWorkerManager;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5742;

public class BiomeSearchWorker
implements WorldWorkerManager.IWorker {
    private final int sampleSpace;
    private final int maxSamples;
    public final int maxRadius;
    private class_3218 world;
    private class_2960 biomeID;
    private class_2338 startPos;
    private int samples;
    private int nextLength;
    private class_2350 direction;
    private class_1799 stack;
    private class_1657 player;
    private int x;
    private int z;
    private int[] yValues;
    private int length;
    private boolean finished;
    private int lastRadiusThreshold;

    public BiomeSearchWorker(class_3218 world, class_1657 player, class_1799 stack, class_1959 biome, class_2338 startPos) {
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.startPos = startPos;
        this.x = startPos.method_10263();
        this.z = startPos.method_10260();
        this.yValues = class_3532.method_42117((int)startPos.method_10264(), (int)(world.method_31607() + 1), (int)world.method_31600(), (int)64).toArray();
        this.sampleSpace = NaturesCompassConfig.sampleSpaceModifier * BiomeUtils.getBiomeSize((class_1937)world);
        this.maxSamples = NaturesCompassConfig.maxSamples;
        this.maxRadius = NaturesCompassConfig.radiusModifier * BiomeUtils.getBiomeSize((class_1937)world);
        this.nextLength = this.sampleSpace;
        this.length = 0;
        this.samples = 0;
        this.direction = class_2350.field_11036;
        this.finished = false;
        this.biomeID = BiomeUtils.getIdentifierForBiome((class_1937)world, biome);
        this.lastRadiusThreshold = 0;
    }

    public void start() {
        if (!this.stack.method_7960() && this.stack.method_7909() == NaturesCompass.NATURES_COMPASS_ITEM) {
            if (this.maxRadius > 0 && this.sampleSpace > 0) {
                NaturesCompass.LOGGER.info("Starting search: " + this.sampleSpace + " sample space, " + this.maxSamples + " max samples, " + this.maxRadius + " max radius");
                WorldWorkerManager.addWorker(this);
            } else {
                this.fail();
            }
        }
    }

    @Override
    public boolean hasWork() {
        return !this.finished && this.getRadius() <= this.maxRadius && this.samples <= this.maxSamples;
    }

    @Override
    public boolean doWork() {
        if (this.hasWork()) {
            int radius;
            if (this.direction == class_2350.field_11043) {
                this.z -= this.sampleSpace;
            } else if (this.direction == class_2350.field_11034) {
                this.x += this.sampleSpace;
            } else if (this.direction == class_2350.field_11035) {
                this.z += this.sampleSpace;
            } else if (this.direction == class_2350.field_11039) {
                this.x -= this.sampleSpace;
            }
            int sampleX = class_5742.method_33100((int)this.x);
            int sampleZ = class_5742.method_33100((int)this.z);
            for (int y : this.yValues) {
                int sampleY = class_5742.method_33100((int)y);
                class_1959 biomeAtPos = (class_1959)this.world.method_14178().method_12129().method_12098().method_38109(sampleX, sampleY, sampleZ, this.world.method_14178().method_41248().method_42371()).comp_349();
                class_2960 biomeAtPosID = BiomeUtils.getIdentifierForBiome((class_1937)this.world, biomeAtPos);
                if (biomeAtPosID == null || !biomeAtPosID.equals((Object)this.biomeID)) continue;
                this.succeed();
                return false;
            }
            ++this.samples;
            this.length += this.sampleSpace;
            if (this.length >= this.nextLength) {
                if (this.direction != class_2350.field_11036) {
                    this.nextLength += this.sampleSpace;
                    this.direction = this.direction.method_10170();
                } else {
                    this.direction = class_2350.field_11043;
                }
                this.length = 0;
            }
            if ((radius = this.getRadius()) > 500 && radius / 500 > this.lastRadiusThreshold) {
                if (!this.stack.method_7960() && this.stack.method_7909() == NaturesCompass.NATURES_COMPASS_ITEM) {
                    ((NaturesCompassItem)this.stack.method_7909()).setSearchRadius(this.stack, this.roundRadius(radius, 500), this.player);
                }
                this.lastRadiusThreshold = radius / 500;
            }
        }
        if (this.hasWork()) {
            return true;
        }
        if (!this.finished) {
            this.fail();
        }
        return false;
    }

    private void succeed() {
        NaturesCompass.LOGGER.info("Search succeeded: " + this.getRadius() + " radius, " + this.samples + " samples");
        if (!this.stack.method_7960() && this.stack.method_7909() == NaturesCompass.NATURES_COMPASS_ITEM) {
            ((NaturesCompassItem)this.stack.method_7909()).succeed(this.stack, this.player, this.x, this.z, this.samples, NaturesCompassConfig.displayCoordinates);
        } else {
            NaturesCompass.LOGGER.error("Invalid compass after search");
        }
        this.finished = true;
    }

    private void fail() {
        NaturesCompass.LOGGER.info("Search failed: " + this.getRadius() + " radius, " + this.samples + " samples");
        if (!this.stack.method_7960() && this.stack.method_7909() == NaturesCompass.NATURES_COMPASS_ITEM) {
            ((NaturesCompassItem)this.stack.method_7909()).fail(this.stack, this.player, this.roundRadius(this.getRadius(), 500), this.samples);
        } else {
            NaturesCompass.LOGGER.error("Invalid compass after search");
        }
        this.finished = true;
    }

    public void stop() {
        NaturesCompass.LOGGER.info("Search stopped: " + this.getRadius() + " radius, " + this.samples + " samples");
        this.finished = true;
    }

    private int getRadius() {
        return BiomeUtils.getDistanceToBiome(this.startPos, this.x, this.z);
    }

    private int roundRadius(int radius, int roundTo) {
        return radius / roundTo * roundTo;
    }
}

